// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/application/public/interfaces/shell.mojom
//

package org.chromium.mojom.mojo;

class Shell_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<Shell, Shell.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<Shell, Shell.Proxy>() {
    
        public String getName() {
            return "mojo::Shell";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, Shell impl) {
            return new Stub(core, impl);
        }
    
        public Shell[] buildArray(int size) {
          return new Shell[size];
        }
    };

    private static final int CONNECT_TO_APPLICATION_ORDINAL = 0;
    private static final int QUIT_APPLICATION_ORDINAL = 1;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements Shell.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void connectToApplication(UrlRequest applicationUrl, org.chromium.mojo.bindings.InterfaceRequest<ServiceProvider> services, ServiceProvider exposedServices, CapabilityFilter filter, ConnectToApplicationResponse callback) {
            ShellConnectToApplicationParams _message = new ShellConnectToApplicationParams();
            _message.applicationUrl = applicationUrl;
            _message.services = services;
            _message.exposedServices = exposedServices;
            _message.filter = filter;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CONNECT_TO_APPLICATION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ShellConnectToApplicationResponseParamsForwardToCallback(callback));
        }

        @Override
        public void quitApplication() {
            ShellQuitApplicationParams _message = new ShellQuitApplicationParams();
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(QUIT_APPLICATION_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<Shell> {

        Stub(org.chromium.mojo.system.Core core, Shell impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                Shell_Internal.MANAGER, messageWithHeader);
                    case QUIT_APPLICATION_ORDINAL: {
                        ShellQuitApplicationParams.deserialize(messageWithHeader.getPayload());
                        getImpl().quitApplication();
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), Shell_Internal.MANAGER, messageWithHeader, receiver);
                    case CONNECT_TO_APPLICATION_ORDINAL: {
                        ShellConnectToApplicationParams data =
                                ShellConnectToApplicationParams.deserialize(messageWithHeader.getPayload());
                        getImpl().connectToApplication(data.applicationUrl, data.services, data.exposedServices, data.filter, new ShellConnectToApplicationResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class ShellConnectToApplicationParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 40;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(40, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public UrlRequest applicationUrl;
        public org.chromium.mojo.bindings.InterfaceRequest<ServiceProvider> services;
        public ServiceProvider exposedServices;
        public CapabilityFilter filter;
    
        private ShellConnectToApplicationParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ShellConnectToApplicationParams() {
            this(0);
        }
    
        public static ShellConnectToApplicationParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ShellConnectToApplicationParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ShellConnectToApplicationParams result = new ShellConnectToApplicationParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.applicationUrl = UrlRequest.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.services = decoder0.readInterfaceRequest(16, true);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.exposedServices = decoder0.readServiceInterface(20, true, ServiceProvider.MANAGER);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, true);
                result.filter = CapabilityFilter.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(applicationUrl, 8, false);
            encoder0.encode(services, 16, true);
            encoder0.encode(exposedServices, 20, true, ServiceProvider.MANAGER);
            encoder0.encode(filter, 32, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ShellConnectToApplicationParams other = (ShellConnectToApplicationParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.applicationUrl, other.applicationUrl))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.services, other.services))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.exposedServices, other.exposedServices))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.filter, other.filter))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(applicationUrl);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(services);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(exposedServices);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(filter);
            return result;
        }
    }

    static final class ShellConnectToApplicationResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int contentHandlerId;
    
        private ShellConnectToApplicationResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ShellConnectToApplicationResponseParams() {
            this(0);
        }
    
        public static ShellConnectToApplicationResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ShellConnectToApplicationResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ShellConnectToApplicationResponseParams result = new ShellConnectToApplicationResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.contentHandlerId = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(contentHandlerId, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ShellConnectToApplicationResponseParams other = (ShellConnectToApplicationResponseParams) object;
            if (this.contentHandlerId != other.contentHandlerId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(contentHandlerId);
            return result;
        }
    }

    static class ShellConnectToApplicationResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final Shell.ConnectToApplicationResponse mCallback;

        ShellConnectToApplicationResponseParamsForwardToCallback(Shell.ConnectToApplicationResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CONNECT_TO_APPLICATION_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                ShellConnectToApplicationResponseParams response = ShellConnectToApplicationResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.contentHandlerId);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ShellConnectToApplicationResponseParamsProxyToResponder implements Shell.ConnectToApplicationResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ShellConnectToApplicationResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer contentHandlerId) {
            ShellConnectToApplicationResponseParams _response = new ShellConnectToApplicationResponseParams();
            _response.contentHandlerId = contentHandlerId;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CONNECT_TO_APPLICATION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class ShellQuitApplicationParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private ShellQuitApplicationParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ShellQuitApplicationParams() {
            this(0);
        }
    
        public static ShellQuitApplicationParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ShellQuitApplicationParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ShellQuitApplicationParams result = new ShellQuitApplicationParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

}

